﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Lista dokumentow wg terminow platnosci</title>
		<script runat="server">

	public enum TypDokumentów {
		Zobowiązania, Należności
	}
	
	public enum Zakres {
		Razem, Kontrahenci, Pracownicy, Urzędy
	}
	
	public class PrnParams: Soneta.Business.OkresContext {
		public PrnParams(Context context): base(context) {
			waluta = WalutyModule.GetInstance(this).Waluty.PLN;
		}
		
		[Priority(1)]
		public override Date Aktualny {
			get { return base.Aktualny; }
			set { base.Aktualny = value; }
		}
		
		[Priority(2)]
		public override FromTo Okres {
			get { return base.Okres; }
			set { base.Okres = value==FromTo.Empty ? FromTo.All : value; }
		}
		
		Zakres zakres = Zakres.Kontrahenci;
		[Priority(3)]
		public Zakres Zakres {
			get { return zakres; }
			set { 
				zakres = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		public RowCondition Condition() {
			switch (zakres) {
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
				case Zakres.Urzędy:
					RowCondition condition = RowCondition.Empty;
					condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					return new RowCondition.Not(condition);
				default:
					return RowCondition.Empty;
			}
		}
				
		IPodmiotKasowy odk;
		[Caption("Od kontrahenta")]
		[Priority(4)]
		public IPodmiotKasowy Od {
			get { return odk; }
			set { 
				odk = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		IPodmiotKasowy dok;
		[Priority(5)]
		[Caption("Do kontrahenta")]
		public IPodmiotKasowy Do {
			get { return dok; }
			set { 
				dok = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		TypDokumentów dokumenty = TypDokumentów.Należności;
		[Priority(6)]
		public TypDokumentów Dokumenty {
			get { return dokumenty; }
			set { 
				dokumenty = value; 
				OnChanged(EventArgs.Empty);
			}
		}			
		
		Waluta waluta;
		[Priority(7)]
		[Required]
		public Waluta Waluta {
			get { return waluta; }
			set { 
				waluta = value; 
				OnChanged(EventArgs.Empty);
			}
		}						
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 


  	[Context(Required = true)]
	public WydrukOddzialParams OParams { get; set; }

	
	Date aktualny;
	FromTo okres;
	bool należności = true;
	string symbol;
	string odKodu;
	string doKodu;

	StanRozliczeniaRozrachunkuWorker worker;
		
						
		
	void OnContextLoad(object sender, EventArgs e) {	
	    aktualny = pars.Aktualny;
	    symbol = pars.Waluta.Symbol.ToUpper();
	    okres = pars.Okres;
		należności = pars.Dokumenty==TypDokumentów.Należności;
		
		worker = new StanRozliczeniaRozrachunkuWorker();
		worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
		
		odKodu = pars.Od == null ? null : pars.Od.Kod.ToUpper();
		doKodu = pars.Do==null ? null : pars.Do.Kod.ToUpper();
		if (odKodu!=null && doKodu!=null && odKodu.CompareTo(doKodu)>0) {
			string s = odKodu;
			odKodu = doKodu;
			doKodu = s;
		}		
		KasaModule kasa = KasaModule.GetInstance(pars);
		RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
		
	Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, aktualny), aktualny);
		view.Condition &=  należności ? kasa.RozrachunkiIdx.NaleznosciEx() : kasa.RozrachunkiIdx.ZobowiazaniaEx();
		view.Condition &= pars.Condition();
    	view.Condition &= OParams.GetConditionIdx();
		
		
		view.FilterCondition += new ConditionHandler(TerminFilter);
		view.FilterCondition += new ConditionHandler(WalutaFilter);
		if (odKodu!=null || doKodu!=null)	    
			view.FilterCondition += new ConditionHandler(PodmiotFilter);	
		Grid1.DataSource = view;
		
        ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
		ReportHeader1["OKRES"] = okres.ToString();
		ReportHeader1["OD"] = HttpUtility.HtmlEncode(odKodu);
		ReportHeader1["DO"] = HttpUtility.HtmlEncode(doKodu);
		ReportHeader1["TYP"] = należności ? "należności" : "zobowiązań";
		ReportHeader1["WALUTA"] = symbol;		
		
		if (pars.Zakres==Zakres.Razem)
			ReportHeader1["ZAKRES"] = "";
		else
			ReportHeader1["ZAKRES"] = "</strong>Zakres: <strong>" + pars.Zakres + "|";		
	}

	void TerminFilter(object sender, ConditionEventArgs args) {
        RozrachunekIdx idx = (RozrachunekIdx)args.Row;
		args.Accepted &= okres.Contains(idx.Termin);
	}
	
	void WalutaFilter(object sender, ConditionEventArgs args) {
        RozrachunekIdx idx = (RozrachunekIdx)args.Row;
		args.Accepted &= idx.Kwota.Symbol==symbol;
	}	

	void PodmiotFilter(object sender, ConditionEventArgs args) {
        RozrachunekIdx idx = (RozrachunekIdx)args.Row;
        string ss = idx.Podmiot.Kod.ToUpper();
		args.Accepted &= (odKodu==null || odKodu.CompareTo(ss)<=0) && (doKodu==null || ss.CompareTo(doKodu)<=0);
	}
	
    int Zwłoka(RozrachunekIdx idx) {
        if (idx.Termin!=Date.Empty) {
            Date data = Date.Min(idx.DataRozliczenia, aktualny);
            if (idx.Termin<data)
                return data-idx.Termin;
        }
        return 0;
    }
	
			
	void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
	{
		RozrachunekIdx idx = (RozrachunekIdx)args.Row;
		worker.RozrachunekIdx = idx;
		
		columnPozostaje.EditValue = należności ? worker.Naleznosc(aktualny).Value : worker.Zobowiazanie(aktualny).Value;
		columnKwota.EditValue = worker.Kwota;
		
		int z = Zwłoka(idx);
		if (z>0) {
			przeterminowane.EditValue = columnPozostaje.EditValue;
			zwłoka.EditValue = z;
		}
	}

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ListaDokumentowWgTerminowPlatnosci" method="post" runat="server">
			<P>
				<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="Lista %TYP% wg terminów płatności|%ODDZIAL%</strong>Stan na dzień: <strong>{0}</strong>, za okres: <strong>%OKRES%|%ZAKRES%</strong>Od kontrahenta: <strong>%OD%</strong>, do kontrahenta: <strong>%DO%|</strong>Waluta: <strong>%WALUTA%" runat="server" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business" DataMember0="Actual"></cc1:ReportHeader>
				<ea:sectionmarker id="SectionMarker2" runat="server"></ea:sectionmarker>
				<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kasa.RozrachunekIdx,Soneta.Kasa" onbeforerow="Grid1_BeforeRow" Sort="Termin" GroupData0="Termin" GroupLine="{0}" ShowGroupSum="True">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
						<ea:GridColumn Width="12" DataMember="Podmiot.Kod" Caption="Kod" NoWrap="True" EncodeHTML="true"></ea:GridColumn>
						<ea:GridColumn Width="36" DataMember="Podmiot.Nazwa" Caption="Nazwa" NoWrap="True" EncodeHTML="true"></ea:GridColumn>
						<ea:GridColumn Width="18" DataMember="Numer" Total="Info" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" ID="columnKwota" Total="Sum" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" ID="columnPozostaje" Total="Sum" Caption="Pozostaje" Format="{0:n}" ></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Przeterminowane" Format="{0:n}" ID="przeterminowane"></ea:GridColumn>
						<ea:GridColumn Align="Right" Caption="Zwł." ID="zwłoka"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<ea:SectionMarker id="SectionMarker1" runat="server" SectionType="Footer"></ea:SectionMarker>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

